//**************************************************************************************
//**************************************************************************************
//****																				****
//****						  HD66773_defs.h										****
//****																				****
//****			Ansteuerung Grafikdisplay Siemens S65 LPH88...						****
//****			Controller: HD66773													****
//****			Auflsung:  132x176 64k Farbe (8-Bit/SPI)							****
//****			copyrigth (c) 2008 by Dipl. Ing. Steffen Taubmann					****
//****																				****
//****			Kontakt: steffenta@gmx.de											****
//****																				****
//**************************************************************************************
//****		 																		****
//****	Fr private Anwender gilt:													****
//****		 																		****
//****		Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen ****
//****		der GNU General Public License, wie von der Free Software Foundation 	****
//****		verffentlicht, weitergeben und/oder modifizieren, entweder gem 		****
//****		Version 3 der Lizenz oder (nach Ihrer Option) jeder spteren Version.	****
//****																				****
//****		Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es	****
//****		Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne	****
//****		die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN	****
//****		BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.	****
//****		 																		****
//****		Sie sollten ein Exemplar der GNU General Public License zusammen mit	****
//****		diesem Programm erhalten haben. 										****
//****		Falls nicht, siehe <http://www.gnu.org/licenses/>.						****
//****																				****
//****	Die kommerzielle Verwendung des Quellcodes bedarf generell der Genehmigung	****
//****	des Autors. Mit kommerzieller Verwendung ist der Verkauf von auf diesem		****
//****	Code basierenden Systemen zu verstehen. Der Einsatz des Systems in einem	****
//****	kommerziellen Umfeld ist davon nicht betroffen.								****
//****																				****
//**************************************************************************************
//**************************************************************************************

#include <string.h>
#define LCD_SetIndexReg 0b01110100		// Set Index Register
#define LCD_WriteData 0b01110110		// Write Instruction or RAM Data

// ----------------   Farbdefinitionen   --------------------

#define Cl_Black 0x0000
#define cl_White 0xFFFF
#define Cl_Blue 0x001F
#define Cl_Green 0x07E0
#define Cl_Cyan 0x7FF
#define Cl_Red 0xF800
#define Cl_Magneta 0xF81F
#define Cl_Yellow 0xFFE0

// ----------------   Textausrichtung   --------------------

#define ta_Left 0x01
#define ta_Right 0x02
#define ta_Center 0x03

// ----------------   Schriftgre   --------------------

#define FT_Large True
#define FT_Small False

// ----------------   Displayauflsung   --------------------

#define X_Size 132
#define Y_Size 176


// ----------------   globale Definitionen fr Farbe und Position   --------------------

#define LCD_BGColor Cl_White			// Hintergrundfarbe Display
#define LCD_BTBGColor Cl_Blue			// Hintergrund fr Buttons
#define LCD_BTFTColor Cl_Yellow			// Schriftfarbe fr Buttons
#define LCD_FTColor Cl_Black			// Schriftfarbe Messwerte

int16 BackGroundColor;
int16 FontColor;
int8 x_Pos;
int8 y_Pos;

// ----------------   5x8 Zeichensatzdefinition   --------------------

const int8 ASCII_Tab_Kl[160][5]={
{0x5C,0x62,0x02,0x62,0x5C}		// ASCII-Code 0x00 (0)
{0x12,0x19,0x15,0x12,0x00}		// ASCII-Code 0x01 (1)
{0x11,0x15,0x15,0x0A,0x00}		// ASCII-Code 0x02 (2)
{0x7F,0x00,0x00,0x00,0x00}		// ASCII-Code 0x03 (3)
{0x7F,0x7F,0x00,0x00,0x00}		// ASCII-Code 0x04 (4)
{0x7F,0x7F,0x7F,0x00,0x00}		// ASCII-Code 0x05 (5)
{0x7F,0x7F,0x7F,0x7F,0x00}		// ASCII-Code 0x06 (6)
{0x7F,0x7F,0x7F,0x7F,0x7F}		// ASCII-Code 0x07 (7)
{0x80,0x80,0x80,0x80,0x80}		// ASCII-Code 0x08 (8)
{0xC0,0xC0,0xC0,0xC0,0xC0}		// ASCII-Code 0x09 (9)
{0xE0,0xE0,0xE0,0xE0,0xE0}		// ASCII-Code 0x0A (10)
{0xF0,0xF0,0xF0,0xF0,0xF0}		// ASCII-Code 0x0B (11)
{0xF8,0xF8,0xF8,0xF8,0xF8}		// ASCII-Code 0x0C (12)
{0xFC,0xFC,0xFC,0xFC,0xFC}		// ASCII-Code 0x0D (13)
{0xFE,0xFE,0xFE,0xFE,0xFE}		// ASCII-Code 0x0E (14)
{0xFF,0xFF,0xFF,0xFF,0xFF}		// ASCII-Code 0x0F (15)
{0x00,0x7F,0x3E,0x1C,0x08}		// ASCII-Code 0x10 (16)
{0x08,0x1C,0x3E,0x7F,0x00}		// ASCII-Code 0x11 (17)
{0x06,0x05,0x00,0x06,0x05}		// ASCII-Code 0x12 (18)
{0x05,0x03,0x00,0x05,0x03}		// ASCII-Code 0x13 (19)
{0x44,0x66,0x77,0x66,0x44}		// ASCII-Code 0x14 (20)
{0x11,0x33,0x77,0x33,0x11}		// ASCII-Code 0x15 (21)
{0x1C,0x3E,0x3E,0x3E,0x1C}		// ASCII-Code 0x16 (22)
{0x10,0x38,0x54,0x10,0x1F}		// ASCII-Code 0x17 (23)
{0x04,0x02,0x7F,0x02,0x04}		// ASCII-Code 0x18 (24)
{0x10,0x20,0x7F,0x20,0x10}		// ASCII-Code 0x19 (25)
{0x08,0x08,0x2A,0x1C,0x08}		// ASCII-Code 0x1A (26)
{0x08,0x1C,0x2A,0x08,0x08}		// ASCII-Code 0x1B (27)
{0x40,0x44,0x4A,0x51,0x40}		// ASCII-Code 0x1C (28)
{0x40,0x51,0x4A,0x44,0x40}		// ASCII-Code 0x1D (29)
{0x20,0x38,0x3E,0x38,0x20}		// ASCII-Code 0x1E (30)
{0x02,0x0E,0x3E,0x0E,0x02}		// ASCII-Code 0x1F (31)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x20 (32)
{0x00,0x00,0x4F,0x00,0x00}		// ASCII-Code 0x21 (33)
{0x00,0x07,0x00,0x07,0x00}		// ASCII-Code 0x22 (34)
{0x14,0x7F,0x14,0x7F,0x14}		// ASCII-Code 0x23 (35)
{0x24,0x2A,0x7F,0x2A,0x12}		// ASCII-Code 0x24 (36)
{0x23,0x13,0x08,0x64,0x62}		// ASCII-Code 0x25 (37)
{0x36,0x49,0x55,0x22,0x50}		// ASCII-Code 0x26 (38)
{0x00,0x05,0x03,0x00,0x00}		// ASCII-Code 0x27 (39)
{0x00,0x1C,0x22,0x41,0x00}		// ASCII-Code 0x28 (40)
{0x00,0x41,0x22,0x1C,0x00}		// ASCII-Code 0x29 (41)
{0x14,0x08,0x3E,0x08,0x14}		// ASCII-Code 0x2A (42)
{0x08,0x08,0x3E,0x08,0x08}		// ASCII-Code 0x2B (43)
{0x00,0x50,0x30,0x00,0x00}		// ASCII-Code 0x2C (44)
{0x08,0x08,0x08,0x08,0x08}		// ASCII-Code 0x2D (45)
{0x00,0x60,0x60,0x00,0x00}		// ASCII-Code 0x2E (46)
{0x20,0x10,0x08,0x04,0x02}		// ASCII-Code 0x2F (47)
{0x3E,0x51,0x49,0x45,0x3E}		// ASCII-Code 0x30 (48)
{0x00,0x42,0x7F,0x40,0x00}		// ASCII-Code 0x31 (49)
{0x42,0x61,0x51,0x49,0x46}		// ASCII-Code 0x32 (50)
{0x21,0x41,0x45,0x4B,0x31}		// ASCII-Code 0x33 (51)
{0x18,0x14,0x12,0x7F,0x10}		// ASCII-Code 0x34 (52)
{0x27,0x45,0x45,0x45,0x39}		// ASCII-Code 0x35 (53)
{0x3C,0x4A,0x49,0x49,0x30}		// ASCII-Code 0x36 (54)
{0x01,0x01,0x79,0x05,0x03}		// ASCII-Code 0x37 (55)
{0x36,0x49,0x49,0x49,0x36}		// ASCII-Code 0x38 (56)
{0x06,0x49,0x49,0x29,0x1E}		// ASCII-Code 0x39 (57)
{0x00,0x36,0x36,0x00,0x00}		// ASCII-Code 0x3A (58)
{0x00,0x56,0x36,0x00,0x00}		// ASCII-Code 0x3B (59)
{0x08,0x14,0x22,0x41,0x00}		// ASCII-Code 0x3C (60)
{0x14,0x14,0x14,0x14,0x14}		// ASCII-Code 0x3D (61)
{0x00,0x41,0x22,0x14,0x08}		// ASCII-Code 0x3E (62)
{0x02,0x01,0x51,0x09,0x06}		// ASCII-Code 0x3F (63)
{0x32,0x79,0x79,0x41,0x3E}		// ASCII-Code 0x40 (64)
{0x7E,0x11,0x11,0x11,0x7E}		// ASCII-Code 0x41 (65)
{0x41,0x7F,0x49,0x49,0x36}		// ASCII-Code 0x42 (66)
{0x3E,0x41,0x41,0x41,0x22}		// ASCII-Code 0x43 (67)
{0x41,0x7F,0x41,0x41,0x3E}		// ASCII-Code 0x44 (68)
{0x7F,0x49,0x49,0x49,0x49}		// ASCII-Code 0x45 (69)
{0x7F,0x09,0x09,0x09,0x01}		// ASCII-Code 0x46 (70)
{0x3E,0x41,0x41,0x49,0x7A}		// ASCII-Code 0x47 (71)
{0x7F,0x08,0x08,0x08,0x7F}		// ASCII-Code 0x48 (72)
{0x00,0x41,0x7F,0x41,0x00}		// ASCII-Code 0x49 (73)
{0x20,0x40,0x41,0x3F,0x01}		// ASCII-Code 0x4A (74)
{0x7F,0x08,0x14,0x22,0x41}		// ASCII-Code 0x4B (75)
{0x7F,0x40,0x40,0x40,0x40}		// ASCII-Code 0x4C (76)
{0x7F,0x02,0x06,0x02,0x7F}		// ASCII-Code 0x4D (77)
{0x7F,0x06,0x08,0x30,0x7F}		// ASCII-Code 0x4E (78)
{0x3E,0x41,0x41,0x41,0x3E}		// ASCII-Code 0x4F (79)
{0x7F,0x09,0x09,0x09,0x06}		// ASCII-Code 0x50 (80)
{0x3E,0x41,0x51,0x21,0x5E}		// ASCII-Code 0x51 (81)
{0x7F,0x09,0x19,0x29,0x46}		// ASCII-Code 0x52 (82)
{0x26,0x49,0x49,0x49,0x32}		// ASCII-Code 0x53 (83)
{0x01,0x01,0x7F,0x01,0x01}		// ASCII-Code 0x54 (84)
{0x3F,0x40,0x40,0x40,0x3F}		// ASCII-Code 0x55 (85)
{0x1F,0x20,0x40,0x20,0x1F}		// ASCII-Code 0x56 (86)
{0x7F,0x20,0x18,0x20,0x7F}		// ASCII-Code 0x57 (87)
{0x63,0x14,0x08,0x14,0x63}		// ASCII-Code 0x58 (88)
{0x07,0x08,0x70,0x08,0x07}		// ASCII-Code 0x59 (89)
{0x61,0x51,0x49,0x45,0x43}		// ASCII-Code 0x5A (90)
{0x00,0x7F,0x41,0x41,0x00}		// ASCII-Code 0x5B (91)
{0x02,0x04,0x08,0x10,0x20}		// ASCII-Code 0x5C (92)
{0x00,0x41,0x41,0x7F,0x00}		// ASCII-Code 0x5D (93)
{0x04,0x02,0x01,0x02,0x04}		// ASCII-Code 0x5E (94)
{0x40,0x40,0x40,0x40,0x40}		// ASCII-Code 0x5F (95)
{0x01,0x02,0x04,0x00,0x00}		// ASCII-Code 0x60 (96)
{0x20,0x54,0x54,0x54,0x78}		// ASCII-Code 0x61 (97)
{0x7F,0x48,0x44,0x44,0x38}		// ASCII-Code 0x62 (98)
{0x38,0x44,0x44,0x44,0x28}		// ASCII-Code 0x63 (99)
{0x38,0x44,0x44,0x48,0x7F}		// ASCII-Code 0x64 (100)
{0x38,0x54,0x54,0x54,0x18}		// ASCII-Code 0x65 (101)
{0x00,0x08,0x7E,0x09,0x02}		// ASCII-Code 0x66 (102)
{0x18,0xA4,0xA4,0x98,0x7C}		// ASCII-Code 0x67 (103)
{0x7F,0x08,0x04,0x04,0x78}		// ASCII-Code 0x68 (104)
{0x00,0x44,0x7D,0x40,0x00}		// ASCII-Code 0x69 (105)
{0x40,0x80,0x84,0x7D,0x00}		// ASCII-Code 0x6A (106)
{0x00,0x7F,0x10,0x28,0x44}		// ASCII-Code 0x6B (107)
{0x00,0x41,0x7F,0x40,0x00}		// ASCII-Code 0x6C (108)
{0x7C,0x04,0x78,0x04,0x78}		// ASCII-Code 0x6D (109)
{0x7C,0x08,0x04,0x04,0x78}		// ASCII-Code 0x6E (110)
{0x38,0x44,0x44,0x44,0x38}		// ASCII-Code 0x6F (111)
{0xFC,0x18,0x24,0x24,0x18}		// ASCII-Code 0x70 (112)
{0x18,0x24,0x24,0x18,0xFC}		// ASCII-Code 0x71 (113)
{0x7C,0x08,0x04,0x04,0x08}		// ASCII-Code 0x72 (114)
{0x58,0x54,0x54,0x54,0x64}		// ASCII-Code 0x73 (115)
{0x04,0x3F,0x44,0x40,0x20}		// ASCII-Code 0x74 (116)
{0x3C,0x40,0x40,0x3C,0x40}		// ASCII-Code 0x75 (117)
{0x1C,0x20,0x40,0x20,0x1C}		// ASCII-Code 0x76 (118)
{0x3C,0x40,0x30,0x40,0x3C}		// ASCII-Code 0x77 (119)
{0x44,0x28,0x10,0x28,0x44}		// ASCII-Code 0x78 (120)
{0x1C,0xA0,0xA0,0x90,0x7C}		// ASCII-Code 0x79 (121)
{0x44,0x64,0x54,0x4C,0x44}		// ASCII-Code 0x7A (122)
{0x00,0x08,0x36,0x41,0x00}		// ASCII-Code 0x7B (123)
{0x00,0x00,0x7F,0x00,0x00}		// ASCII-Code 0x7C (124)
{0x00,0x41,0x36,0x08,0x00}		// ASCII-Code 0x7D (125)
{0x10,0x08,0x08,0x10,0x08}		// ASCII-Code 0x7E (126)
{0x00,0x06,0x09,0x09,0x06}		// ASCII-Code 0x7F (127)
{0x30,0x28,0x24,0x28,0x30}		// ASCII-Code 0x80 (128)
{0x38,0x42,0x40,0x3A,0x40}		// ASCII-Code 0x81 (129)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x82 (130)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x83 (131)
{0x20,0x55,0x54,0x55,0x78}		// ASCII-Code 0x84 (132)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x85 (133)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x86 (134)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x87 (135)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x88 (136)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x89 (137)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x8A (138)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x8B (139)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x8C (140)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x8D (141)
{0x78,0x25,0x24,0x25,0x78}		// ASCII-Code 0x8E (142)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x8F (143)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x90 (144)
{0x24,0x54,0x7C,0x54,0x58}		// ASCII-Code 0x91 (145)
{0x7E,0x11,0x7F,0x49,0x41}		// ASCII-Code 0x92 (146)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x93 (147)
{0x30,0x4A,0x48,0x4A,0x30}		// ASCII-Code 0x94 (148)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x95 (149)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x96 (150)
{0x00,0x00,0x00,0x00,0x00}		// ASCII-Code 0x97 (151)
{0x1C,0x36,0x55,0x55,0x41}		// ASCII-Code 0x98 (152)
{0x38,0x45,0x44,0x45,0x38}		// ASCII-Code 0x99 (153)
{0x38,0x42,0x40,0x42,0x38}		// ASCII-Code 0x9A (154)
{0x1C,0x22,0x7F,0x22,0x14}		// ASCII-Code 0x9B (155)
{0x68,0x7E,0x29,0x41,0x22}		// ASCII-Code 0x9C (156)
{0x29,0x2A,0x7C,0x2A,0x29}		// ASCII-Code 0x9D (157)
{0x77,0x05,0x12,0x7C,0x50}		// ASCII-Code 0x9E (158)
{0x48,0x7E,0x49,0x01,0x02}		// ASCII-Code 0x9F (159)
};

// ----------------   8x14 Zeichensatzdefinition   --------------------

const int8 ASCII_Tab_GR[160][14]={
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x00 (0)
{0x3F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x3F}		// ASCII-Code 0x01 (1)
{0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF}		// ASCII-Code 0x02 (2)
{0xFC, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFC}		// ASCII-Code 0x03 (3)
{0x00, 0x00, 0x00, 0x00, 0x18, 0x3C, 0x7E, 0x7E, 0x3C, 0x18, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x04 (4)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x05 (5)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x06 (6)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x07 (7)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x08 (8)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x09 (9)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x0A (10)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x0B (11)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x0C (12)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x0D (13)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x0E (14)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x0F (15)
{0x00, 0x21, 0x32, 0xFA, 0x32, 0x22, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x00}		// ASCII-Code 0x10 (16)
{0x00, 0x01, 0x02, 0x22, 0x32, 0xFA, 0x32, 0x22, 0x02, 0x02, 0x02, 0x02, 0x01, 0x00}		// ASCII-Code 0x11 (17)
{0x00, 0x01, 0x02, 0x02, 0x02, 0x02, 0x22, 0x32, 0xFA, 0x32, 0x22, 0x02, 0x01, 0x00}		// ASCII-Code 0x12 (18)
{0x00, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x22, 0x32, 0xFA, 0x32, 0x21, 0x00}		// ASCII-Code 0x13 (19)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x14 (20)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x15 (21)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x16 (22)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x17 (23)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x18 (24)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x19 (25)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x1A (26)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x1B (27)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x1C (28)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x1D (29)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x1E (30)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x1F (31)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x20 (32)
{0x00, 0x00, 0x00, 0x18, 0x3C, 0x3C, 0x3C, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00}		// ASCII-Code 0x21 (33)
{0x00, 0x66, 0x66, 0x66, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x22 (34)
{0x00, 0x00, 0x00, 0x6C, 0x6C, 0xFE, 0x6C, 0x6C, 0x6C, 0xFE, 0x6C, 0x6C, 0x00, 0x00}		// ASCII-Code 0x23 (35)
{0x00, 0x18, 0x18, 0x7C, 0xC6, 0xC2, 0xC0, 0x7C, 0x06, 0x86, 0xC6, 0x7C, 0x18, 0x18}		// ASCII-Code 0x24 (36)
{0x00, 0x00, 0x00, 0x00, 0x00, 0xC2, 0xC6, 0x0C, 0x18, 0x30, 0x66, 0xC6, 0x00, 0x00}		// ASCII-Code 0x25 (37)
{0x00, 0x00, 0x00, 0x38, 0x6C, 0x6C, 0x38, 0x76, 0xDC, 0xCC, 0xCC, 0x76, 0x00, 0x00}		// ASCII-Code 0x26 (38)
{0x00, 0x18, 0x18, 0x18, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x27 (39)
{0x00, 0x00, 0x00, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x30, 0x30, 0x18, 0x0C, 0x00, 0x00}		// ASCII-Code 0x28 (40)
{0x00, 0x00, 0x00, 0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x18, 0x30, 0x00, 0x00}		// ASCII-Code 0x29 (41)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x2A (42)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x7E, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x2B (43)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x30, 0x00}		// ASCII-Code 0x2C (44)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x2D (45)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00}		// ASCII-Code 0x2E (46)
{0x00, 0x00, 0x00, 0x02, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x80, 0x00, 0x00, 0x00}		// ASCII-Code 0x2F (47)
{0x00, 0x00, 0x00, 0x38, 0x6C, 0xC6, 0xC6, 0xD6, 0xC6, 0xC6, 0x6C, 0x38, 0x00, 0x00}		// ASCII-Code 0x30 (48)
{0x00, 0x00, 0x00, 0x18, 0x38, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x00, 0x00}		// ASCII-Code 0x31 (49)
{0x00, 0x00, 0x00, 0x7C, 0xC6, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC6, 0xFE, 0x00, 0x00}		// ASCII-Code 0x32 (50)
{0x00, 0x00, 0x00, 0x7C, 0xC6, 0x06, 0x06, 0x3C, 0x06, 0x06, 0xC6, 0x7C, 0x00, 0x00}		// ASCII-Code 0x33 (51)
{0x00, 0x00, 0x00, 0x0C, 0x1C, 0x3C, 0x6C, 0xCC, 0xFE, 0x0C, 0x0C, 0x1E, 0x00, 0x00}		// ASCII-Code 0x34 (52)
{0x00, 0x00, 0x00, 0xFE, 0xC0, 0xC0, 0xC0, 0xFC, 0x06, 0x06, 0xC6, 0x7C, 0x00, 0x00}		// ASCII-Code 0x35 (53)
{0x00, 0x00, 0x00, 0x38, 0x60, 0xC0, 0xC0, 0xFC, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00}		// ASCII-Code 0x36 (54)
{0x00, 0x00, 0x00, 0xFE, 0xC6, 0x06, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00}		// ASCII-Code 0x37 (55)
{0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0x7C, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00}		// ASCII-Code 0x38 (56)
{0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0x7E, 0x06, 0x06, 0x0C, 0x78, 0x00, 0x00}		// ASCII-Code 0x39 (57)
{0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00}		// ASCII-Code 0x3A (58)
{0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x00, 0x00}		// ASCII-Code 0x3B (59)
{0x00, 0x00, 0x00, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x60, 0x30, 0x18, 0x0C, 0x00, 0x00}		// ASCII-Code 0x3C (60)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x3D (61)
{0x00, 0x00, 0x00, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x0C, 0x18, 0x30, 0x60, 0x00, 0x00}		// ASCII-Code 0x3E (62)
{0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0x0C, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00}		// ASCII-Code 0x3F (63)
{0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xDE, 0xDE, 0xDE, 0xDC, 0xC0, 0x7C, 0x00, 0x00}		// ASCII-Code 0x40 (64)
{0x00, 0x00, 0x00, 0x10, 0x38, 0x6C, 0xC6, 0xC6, 0xFE, 0xC6, 0xC6, 0xC6, 0x00, 0x00}		// ASCII-Code 0x41 (65)
{0x00, 0x00, 0x00, 0xFC, 0x66, 0x66, 0x66, 0x7C, 0x66, 0x66, 0x66, 0xFC, 0x00, 0x00}		// ASCII-Code 0x42 (66)
{0x00, 0x00, 0x00, 0x3C, 0x66, 0xC2, 0xC0, 0xC0, 0xC0, 0xC2, 0x66, 0x3C, 0x00, 0x00}		// ASCII-Code 0x43 (67)
{0x00, 0x00, 0x00, 0xF8, 0x6C, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6C, 0xF8, 0x00, 0x00}		// ASCII-Code 0x44 (68)
{0x00, 0x00, 0x00, 0xFE, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xFE, 0x00, 0x00}		// ASCII-Code 0x45 (69)
{0x00, 0x00, 0x00, 0xFE, 0x66, 0x62, 0x68, 0x78, 0x68, 0x60, 0x60, 0xF0, 0x00, 0x00}		// ASCII-Code 0x46 (70)
{0x00, 0x00, 0x00, 0x3C, 0x66, 0xC2, 0xC0, 0xC0, 0xDE, 0xC6, 0x66, 0x3A, 0x00, 0x00}		// ASCII-Code 0x47 (71)
{0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xFE, 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00}		// ASCII-Code 0x48 (72)
{0x00, 0x00, 0x00, 0x3C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00}		// ASCII-Code 0x49 (73)
{0x00, 0x00, 0x00, 0x1E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xCC, 0xCC, 0x78, 0x00, 0x00}		// ASCII-Code 0x4A (74)
{0x00, 0x00, 0x00, 0xE6, 0x66, 0x6C, 0x6C, 0x78, 0x6C, 0x6C, 0x66, 0xE6, 0x00, 0x00}		// ASCII-Code 0x4B (75)
{0x00, 0x00, 0x00, 0xF0, 0x60, 0x60, 0x60, 0x60, 0x60, 0x62, 0x66, 0xFE, 0x00, 0x00}		// ASCII-Code 0x4C (76)
{0x00, 0x00, 0x00, 0xC6, 0xEE, 0xFE, 0xD6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00}		// ASCII-Code 0x4D (77)
{0x00, 0x00, 0x00, 0xC6, 0xE6, 0xF6, 0xFE, 0xDE, 0xCE, 0xC6, 0xC6, 0xC6, 0x00, 0x00}		// ASCII-Code 0x4E (78)
{0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00}		// ASCII-Code 0x4F (79)
{0x00, 0x00, 0x00, 0xFC, 0x66, 0x66, 0x66, 0x7C, 0x60, 0x60, 0x60, 0xF0, 0x00, 0x00}		// ASCII-Code 0x50 (80)
{0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xD6, 0xDE, 0x7C, 0x0E, 0x00}		// ASCII-Code 0x51 (81)
{0x00, 0x00, 0x00, 0xFC, 0x66, 0x66, 0x66, 0x7C, 0x6C, 0x66, 0x66, 0xE6, 0x00, 0x00}		// ASCII-Code 0x52 (82)
{0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0x60, 0x38, 0x0C, 0xC6, 0xC6, 0x7C, 0x00, 0x00}		// ASCII-Code 0x53 (83)
{0x00, 0x00, 0x00, 0x7E, 0x7E, 0x5A, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00}		// ASCII-Code 0x54 (84)
{0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00}		// ASCII-Code 0x55 (85)
{0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x6C, 0x38, 0x10, 0x00, 0x00}		// ASCII-Code 0x56 (86)
{0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xD6, 0xD6, 0xFE, 0x6C, 0x6C, 0x00, 0x00}		// ASCII-Code 0x57 (87)
{0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0x7C, 0x38, 0x7C, 0xC6, 0xC6, 0xC6, 0x00, 0x00}		// ASCII-Code 0x58 (88)
{0x00, 0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00}		// ASCII-Code 0x59 (89)
{0x00, 0x00, 0x00, 0xFE, 0xC6, 0x8C, 0x18, 0x30, 0x60, 0xC2, 0xC6, 0xFE, 0x00, 0x00}		// ASCII-Code 0x5A (90)
{0x00, 0x00, 0x00, 0x3C, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 0x00, 0x00}		// ASCII-Code 0x5B (91)
{0x00, 0x00, 0x00, 0x80, 0xC0, 0xE0, 0x70, 0x38, 0x1C, 0x0E, 0x06, 0x02, 0x00, 0x00}		// ASCII-Code 0x5C (92)
{0x00, 0x00, 0x00, 0x3C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3C, 0x00, 0x00}		// ASCII-Code 0x5D (93)
{0x10, 0x38, 0x6C, 0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x5E (94)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF}		// ASCII-Code 0x5F (95)
{0x00, 0x30, 0x18, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x60 (96)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x0C, 0x7C, 0xCC, 0xCC, 0x76, 0x00, 0x00}		// ASCII-Code 0x61 (97)
{0x00, 0x00, 0x00, 0xE0, 0x60, 0x60, 0x78, 0x6C, 0x66, 0x66, 0x66, 0x7C, 0x00, 0x00}		// ASCII-Code 0x62 (98)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC0, 0xC0, 0xC6, 0x7C, 0x00, 0x00}		// ASCII-Code 0x63 (99)
{0x00, 0x00, 0x00, 0x1C, 0x0C, 0x0C, 0x3C, 0x6C, 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00}		// ASCII-Code 0x64 (100)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xFE, 0xC0, 0xC6, 0x7C, 0x00, 0x00}		// ASCII-Code 0x65 (101)
{0x00, 0x00, 0x00, 0x1C, 0x36, 0x32, 0x30, 0x7C, 0x30, 0x30, 0x30, 0x78, 0x00, 0x00}		// ASCII-Code 0x66 (102)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xCC, 0xCC, 0xCC, 0x7C, 0x0C, 0xCC, 0x78}		// ASCII-Code 0x67 (103)
{0x00, 0x00, 0x00, 0xE0, 0x60, 0x60, 0x6C, 0x76, 0x66, 0x66, 0x66, 0xE6, 0x00, 0x00}		// ASCII-Code 0x68 (104)
{0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00}		// ASCII-Code 0x69 (105)
{0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x0E, 0x06, 0x06, 0x06, 0x06, 0x66, 0x66, 0x3C}		// ASCII-Code 0x6A (106)
{0x00, 0x00, 0x00, 0xE0, 0x60, 0x60, 0x66, 0x6C, 0x78, 0x6C, 0x66, 0xE6, 0x00, 0x00}		// ASCII-Code 0x6B (107)
{0x00, 0x00, 0x00, 0x38, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00, 0x00}		// ASCII-Code 0x6C (108)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0xFE, 0xD6, 0xD6, 0xD6, 0xD6, 0x00, 0x00}		// ASCII-Code 0x6D (109)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDC, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00}		// ASCII-Code 0x6E (110)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00}		// ASCII-Code 0x6F (111)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDC, 0x66, 0x66, 0x66, 0x7C, 0x60, 0x60, 0xF0}		// ASCII-Code 0x70 (112)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0xCC, 0xCC, 0xCC, 0x7C, 0x0C, 0x0C, 0x1E}		// ASCII-Code 0x71 (113)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDC, 0x76, 0x66, 0x60, 0x60, 0xF0, 0x00, 0x00}		// ASCII-Code 0x72 (114)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0xC6, 0x70, 0x1C, 0xC6, 0x7C, 0x00, 0x00}		// ASCII-Code 0x73 (115)
{0x00, 0x00, 0x00, 0x10, 0x30, 0x30, 0xFC, 0x30, 0x30, 0x30, 0x36, 0x1C, 0x00, 0x00}		// ASCII-Code 0x74 (116)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00}		// ASCII-Code 0x75 (117)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0x6C, 0x38, 0x10, 0x00, 0x00}		// ASCII-Code 0x76 (118)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xD6, 0xD6, 0xFE, 0x6C, 0x00, 0x00}		// ASCII-Code 0x77 (119)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0x6C, 0x38, 0x38, 0x6C, 0xC6, 0x00, 0x00}		// ASCII-Code 0x78 (120)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0x7E, 0x06, 0x0C, 0x78}		// ASCII-Code 0x79 (121)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xCC, 0x18, 0x30, 0x66, 0xFE, 0x00, 0x00}		// ASCII-Code 0x7A (122)
{0x00, 0x00, 0x00, 0x0E, 0x18, 0x18, 0x18, 0x70, 0x18, 0x18, 0x18, 0x0E, 0x00, 0x00}		// ASCII-Code 0x7B (123)
{0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00}		// ASCII-Code 0x7C (124)
{0x00, 0x00, 0x00, 0x70, 0x18, 0x18, 0x18, 0x0E, 0x18, 0x18, 0x18, 0x70, 0x00, 0x00}		// ASCII-Code 0x7D (125)
{0x00, 0x76, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x7E (126)
{0x00, 0x1C, 0x36, 0x36, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x7F (127)
{0x00, 0x00, 0x00, 0x10, 0x38, 0x6C, 0xC6, 0x82, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x80 (128)
{0x00, 0x00, 0x00, 0xCC, 0xCC, 0x00, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x76, 0x00, 0x00}		// ASCII-Code 0x81 (129)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x82 (130)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x83 (131)
{0x00, 0x00, 0x00, 0xCC, 0xCC, 0x00, 0x78, 0x0C, 0x7C, 0xCC, 0xCC, 0x76, 0x00, 0x00}		// ASCII-Code 0x84 (132)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x85 (133)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x86 (134)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x87 (135)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x88 (136)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x89 (137)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x8A (138)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x8B (139)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x8C (140)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x8D (141)
{0x00, 0xC6, 0xC6, 0x10, 0x38, 0x6C, 0xC6, 0xC6, 0xFE, 0xC6, 0xC6, 0xC6, 0x00, 0x00}		// ASCII-Code 0x8E (142)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x8F (143)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x90 (144)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x91 (145)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x92 (146)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x93 (147)
{0x00, 0x00, 0x00, 0xC6, 0xC6, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00}		// ASCII-Code 0x94 (148)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x95 (149)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x96 (150)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x97 (151)
{0x00, 0x00, 0x00, 0x3C, 0x66, 0xC2, 0xF8, 0xC0, 0xF8, 0xC2, 0x66, 0x3C, 0x00, 0x00}		// ASCII-Code 0x98 (152)
{0xC6, 0xC6, 0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00}		// ASCII-Code 0x99 (153)
{0xC6, 0xC6, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00, 0x00}		// ASCII-Code 0x9A (154)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x9B (155)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x9C (156)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x9D (157)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x9E (158)
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}		// ASCII-Code 0x9F (159)};
};


// ----------------   Initialisierungssequenzen   		--------------------
// ----------------   Aufbau: {Register,Upper,Lower}    --------------------


const int8 LCDInit1 [6][3]={
	{0x07,0x00,0x00}
	{0x02,0x04,0x00}
	{0x04,0x00,0x00}
	{0x0C,0x00,0x01}
	{0x0D,0x06,0x16}
	{0x0E,0x10,0x10}};

const int8 LCDInit2[2][3]={
	{0x03,0x00,0x0C}
	{0x0E,0x2D,0x1F}};

const int8 LCDInit3[1][3]={
	{0x0D,0x06,0x16}};

const int8 LCDInit4[21][3]={
	{0x01,0x01,0x15}
//	{0x01,0x03,0x15}
	{0x0F,0x00,0x00}
	{0x0B,0x00,0x00}
	{0x11,0x00,0x00}
	{0x06,0x00,0x00}
	{0x05,0x00,0x38}
	{0x14,0xAF,0x00}
	{0x15,0x00,0x00}
	{0x16,0x83,0x00}
	{0x17,0xAF,0x00}
	{0x20,0x00,0x00}
	{0x30,0x00,0x00}
	{0x31,0x04,0x00}
	{0x32,0x02,0x07}
	{0x33,0x07,0x00}
	{0x34,0x00,0x05}
	{0x35,0x07,0x03}
	{0x36,0x07,0x07}
	{0x37,0x00,0x07}
	{0x3A,0x12,0x00}
	{0x3B,0x00,0x09}};


// ----------------   Ansteuerung des Displays per SPI       --------------------
// ----------------   laut Datenblatt max. 10MHz SPI-Clock   --------------------


//**********************************************************
//****
//**** Indexregister setzen
//****
//**********************************************************

void SetLCDIndexReg(int8 IndexReg)
{ LCD_CS=0;
  SPI_Write(0x74);						// Startbyte, RS=0, RW=0
  SPI_Write(0);
  SPI_Write(IndexReg);
  LCD_CS=1;								// Transfer End
}

//**********************************************************
//****
//**** 16-Bit Datenblock in RAM schreiben
//****
//**********************************************************

void WriteLCDDataBlock(int16* Data, int16 Anz)
{ int16 i;
  int8 Upper;
  int8 Lower;

  LCD_CS=0;  
  SPI_Write(0x76);						// StartByte RS=1, RW=0
  for(i=0; i<Anz; ++i)
  { Upper=Data[i]>>8;
	Lower=Data[i]&0x00FF;
	SPI_Write(Upper);
	SPI_Write(Lower);
  }
  LCD_CS=1;
}

//**********************************************************
//****
//**** 16-Bit Datenword in RAM bzw. Indexregister schreiben
//****
//**********************************************************

void WriteLCDWord(int16 Dataword)
{ int8 Upper;
  int8 Lower;

  LCD_CS=0;  
  SPI_Write(0x76);						// StartByte RS=1, RW=0
  Upper=Dataword>>8;
  Lower=Dataword&0x00FF;
  SPI_Write(Upper);
  SPI_Write(Lower);
  LCD_CS=1;
}

//**********************************************************
//****
//**** 2x8 Bit Datenbyte in RAM bzw. Indexregister schreiben
//****
//**********************************************************

void WriteLCDBytes(int8 Data1, Data2)
{ 
  LCD_CS=0;  
  SPI_Write(0x76);						// StartByte RS=1, RW=0
  SPI_Write(Data1);
  SPI_Write(Data2);
  LCD_CS=1;
}

//**********************************************************
//****
//**** 16 Bit Datenword in Indexregister schreiben
//****
//**********************************************************

void WriteLCDIndexReg(int8 Reg, int16 Data)
{ SetLCDIndexReg(Reg); WriteLCDWord(Data);
}

//**********************************************************
//****
//**** 2x8 Bit Datenbyte in Indexregister schreiben
//****
//**********************************************************

void WriteLCDIndexReg_B(int8 Reg, Data1,Data2)
{ SetLCDIndexReg(Reg); WriteLCDBytes(Data1,Data2);
}

//**********************************************************
//****
//**** Displayinitialisierung nach Power On
//****
//**********************************************************

void LCDPowerOn()
{ int8 i;
  int16 Value;

  LCD_Reset=0; Delay_ms(1); LCD_Reset=1;	// Reset
  Delay_ms(10);								// Wait until RC Oscilator is stabel
  WriteLCDIndexReg(0,1);					// Start Oscilation

  // Step 1
  for (i=0; i<6; ++i)
  { Value=LCDInit1[i][1]; Value<<=8; Value+=LCDInit1[i][2];
	WriteLCDIndexReg(LCDInit1[i][0],Value);	
  }
  // Step 2
  for (i=0; i<2; ++i)
  { Value=LCDInit2[i][1]; Value<<=8; Value+=LCDInit2[i][2];
	WriteLCDIndexReg(LCDInit2[i][0],Value);	
  }
  
  Delay_ms(40);

  // Step 3
  Value=LCDInit3[0][1]; Value<<=8; Value+=LCDInit3[0][2];
  WriteLCDIndexReg(LCDInit3[0][0],Value);	

  Delay_ms(40);

  // Step 4
  for (i=0; i<21; ++i)
  { Value=LCDInit4[i][1]; Value<<=8; Value+=LCDInit4[i][2];
	WriteLCDIndexReg(LCDInit4[i][0],Value);	
  }
  
  Delay_ms(100);
}

//**********************************************************
//****
//**** Display On Sequenze
//****
//**********************************************************

void LCDDisplayOn()
{ WriteLCDIndexReg(7,5);
  WriteLCDIndexReg(7,0x25);
  WriteLCDIndexReg(7,0x27);
  WriteLCDIndexReg(7,0x37);
}

//**********************************************************
//****
//**** Display (Power) Off Sequenze
//****
//**********************************************************

void LCDPowerOff()
{ WriteLCDIndexReg(0x0B,0);
  WriteLCDIndexReg(7,0x32);
  WriteLCDIndexReg(7,0x22);
  WriteLCDIndexReg(7,0x0);
  WriteLCDIndexReg(3,0x60);
  Delay_ms(100);
  WriteLCDIndexReg(0x0D,0);
  WriteLCDIndexReg(0x0E,0);
  WriteLCDIndexReg(0x03,0);
}

//**********************************************************
//****
//**** Display lschen
//****
//**********************************************************

void LCDCLS()
{ int16 i;
  WriteLCDIndexReg(0x16,0x8300);
  WriteLCDIndexReg(0x17,0xAF00);
  WriteLCDIndexReg(0x21,0);

  SetLCDIndexReg(0x22);
  for(i=0;i<132*176;++i) WriteLCDWord(BackGroundColor);
}

//**********************************************************
//****
//**** Zeichenausgabe an aktueller Position
//****   Large=True --> Zeichensatz 8x14
//****   Large=False --> Zeichensatz 6(5)x8
//****
//****   X_Pos wird nach ausfhrung auf nchste Pos. gesetzt
//****
//**********************************************************

void LCDPutChar(char C, short Large)
{ int8 h,p,ch,mask,CharWith;
  int16 ChrBuffer[120];

  if(Large)
  { WriteLCDIndexReg_B(0x05,0x00,0x30);			// Entry Mode set
	CharWith=14; 
	WriteLCDIndexReg_B(0x16,x_Pos+7,x_Pos);
	WriteLCDIndexReg_B(0x17,y_Pos,y_Pos-13);	// Ausgabefenster
    WriteLCDIndexReg_B(0x21,y_Pos-13,x_Pos);	// Fensterposition
  }
  else
  { WriteLCDIndexReg_B(0x05,0x00,0x18);			// Entry Mode set
	CharWith=6; 
	WriteLCDIndexReg_B(0x16,x_Pos+5,x_Pos);
	WriteLCDIndexReg_B(0x17,y_Pos,y_Pos-7);		// Ausgabefenster
    WriteLCDIndexReg_B(0x21,y_Pos,x_Pos);		// Fensterposition
  }

  SetLCDIndexReg(0x22);							// Ausgabe in RAM

  for (h=0; h<CharWith; ++h)					// Zeilen/Spalten ASCII Table
  { if (Large)
	  ch=ASCII_Tab_Gr[c][h];	
	else
	  if(h<5) ch=ASCII_Tab_Kl[c][h]; else ch=0;	// Spalte 6 auf 0 setzen, da nicht in ASCII-Table gespeichert
	  
	mask=0x80;
	for (p=0; p<8; ++p)  						// einzelne Pixel setzen
    { if (ch&mask)
        ChrBuffer[h*8+p]=FontColor;
      else
        ChrBuffer[h*8+p]=BackGroundColor;
	  mask>>=1;
    }  // for p
  }

  WriteLCDDataBlock(ChrBuffer,CharWith*8);		// komplettes Zeichen Schreiben

  if(Large)
  { /*if (X_pos+8<X_Size-8)*/ X_Pos+=8;} 		// Position nchstes Zeichen in einer Zeile
  else 
  { /*if (X_pos+6<X_Size-6)*/ X_Pos+=6;} 		// Position nchstes Zeichen in einer Zeile
}

//**********************************************************
//****
//**** String ausgeben
//****   x,y           : Ausgabeposition
//****   Text          : Auszugebender String
//****   Large=True  --> Zeichensatz 8x14
//****   Large=False --> Zeichensatz 6(5)x8
//****   d             : Textorientierung
//****   				 (ta_Left, ta_Right, ta_Center)
//****
//**********************************************************

void LCDPutString(int8 x,y, char* Text, short Large, int8 D)
{ int8 CharWith;
  if(Large) CharWith=8; else CharWith=6;
  switch(D)
  { case ta_Left: X_Pos=X; Y_Pos=y; break;
	case ta_Right: X_Pos=X-(StrLen(Text)*CharWith)+1; Y_Pos=y; break;
	case ta_Center: X_Pos=X-(StrLen(Text)*CharWith/2); Y_Pos=y; break;
	default: X_Pos=X; Y_Pos=y; break;
  }
  while(*Text!='\0')
  { LCDPutChar(*Text,Large);
	++Text;
  }
}

//**********************************************************
//****
//**** geflltes Rechteck zeichnen
//****   xs,ys      : Startposition
//****   xe,ye      : Endposition
//****   Color		: Farbe
//****
//**********************************************************

void LCD_Rect(int8 xs,ys,xe,ye,int16 color)
{ int16 x,a;

  WriteLCDIndexReg_B(0x05,0x00,0x38);		// Entry Mode set
  WriteLCDIndexReg_B(0x16,xe,xs);
  WriteLCDIndexReg_B(0x17,ye,ys);			// Ausgabefenster
  WriteLCDIndexReg_B(0x21,xs,ys);			// Fensterposition
  SetLCDIndexReg(0x22);						// Ausgabe in RAM
  a=(xe-xs)+1;a*=(ye-ys+1);
  for(x=0; x<a; ++x)
	WriteLCDWord(Color);
}
